Option Explicit

Dim oPath, oShowError
Dim strComputer, errReturn
Dim objService, objWMIService, colListOfServices, oService
Dim bAllowDelete
Dim dtStart
Dim sServiceState
Dim lElapsed
Dim oFSO
Dim WshShell, sKey
Dim serviceName
Dim productName
Dim productVersion
Dim objFSO, objShell
Dim logStream
Dim folder, files, file, deleteError
Dim regValueName, regValue

set objShell = CreateObject("WScript.Shell")

On Error Resume Next
oPath = wscript.arguments.named("path")
If wscript.arguments.named.exists("interactive") And Lcase(wscript.arguments.named("interactive")) = "true" Then
    oShowError = True
Else
    oShowError = False
End If

If wscript.arguments.named.exists("serviceName") Then
    serviceName = wscript.arguments.named("serviceName")
Else
    serviceName = "cuAgent"
End If

WriteLog("Uninstall Script invoked for service " & serviceName)

If wscript.arguments.named.exists("productName") Then
    productName = wscript.arguments.named("productName")
Else
    productName = "ControlUpAgent"
End If

If wscript.arguments.named.exists("productVersion") Then
    productVersion = wscript.arguments.named("productVersion")
End If


Err.Clear


strComputer = "."
Set objWMIService = GetObject("winmgmts:{impersonationLevel=impersonate}!\\" & strComputer & "\root\cimv2")

bAllowDelete = False
dtStart = Now		
WriteLog("Stopping Services")
Do Until bAllowDelete
	Set colListOfServices = objWMIService.ExecQuery("Select * from Win32_Service Where Name = '" & serviceName & "'")
	Err.Clear
	if colListOfServices.Count = 0 Then
				if oShowError = True then
					MsgBox "Service not found. " & Err.Description
				End If
		WriteErr("Service Not Found : " & serviceName)
		Exit Do
	End If
	Wscript.sleep(1000)
	For Each objService In colListOfServices
		Set oService = objService
		sServiceState = objService.State
		If sServiceState <> "Stopped" Then
			Err.Clear
			Call objService.StopService
			If Err.number <> 0 Then
				if oShowError = True then
					MsgBox "An error occurred while stopping service. " & Err.Description
				End If
				WriteErr("An error occurred while stopping the service : " & Err.Description)
			End If
		Else
			bAllowDelete = True
		End If
	Next
	
	lElapsed = DateDiff("s", dtStart, Now)
	If lElapsed > 60 Then
		bAllowDelete = True
	End If
	
	If bAllowDelete = True Then
		For Each objService In colListOfServices
			WriteLog("Deleting Services")
			Err.Clear
			Call objService.Delete
			If Err.number <> 0 Then
				if oShowError = True then
					MsgBox "An error occurred while removing service. " & Err.Description
				End If
				WriteErr("An error occurred while deleting the service : " & Err.Description)
			End If

		Next
	    
	End If
Loop

If Err.number <> 0 Then
	'ServiceErr:
				if oShowError = True then
					MsgBox "An error occurred while stopping and removing service. " & Err.Description
				End If

	WriteLog("An error occurred while stopping and removing service. " & Err.Description)
Else
	'Delete:
	Set oFSO = WScript.CreateObject("scripting.filesystemobject")
	wscript.sleep(5000)
	WriteLog("Deleting Folder")
	Err.Clear

	deleteError = ""
   Set folder = oFso.GetFolder(oPath)
   Set files = folder.Files
   For Each file in files
       Call file.Delete(True)
       If Err.Number <> 0 Then
			If file.Name = "perfmod32.dll" Or file.Name = "perfmod64.dll" Then
                regValueName = "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\RunOnce\" & "ControlUpAgent_" & productVersion & "_" & file.Name
                regValue = "cmd /q /c ""del /f /q """ & file.Path & """"""
				Set WshShell = WScript.CreateObject("WScript.Shell")
				WshShell.RegWrite regValueName, regValue
            Else
				deleteError = Err.Description
            End If
       End If
	   Err.Clear
   Next
	 oFSO.DeleteFolder folder.Path, True

	If deleteError <> "" Then
		'DeleteErr:
				if oShowError = True then
					MsgBox "An error occurred while deleting the folder: " & deleteError
				End If

		WriteErr("An error occurred while deleting the folder: " & deleteError)
	Else
		'RemoveAppWiz:
		WriteLog("Deleting registry entries")
		Set WshShell = WScript.CreateObject("WScript.Shell")
		sKey = "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\" & productName & "\"
		Err.Clear
		WshShell.RegDelete (sKey)
			If Err.number <> 0 Then
				WriteLog("An error occurred while deleting the registry key: " & Err.Description)
			End If
	End If
	
End If

WriteLog( productName & " uninstall process completed.")
if oShowError = True then
	MsgBox productName & " uninstall process completed."
End If


Function WriteLog(strMessage)
	objShell.LogEvent 4, "Message from " & productName & " uninstall script: " & strMessage
End Function

Function WriteErr(strMessage)
	objShell.LogEvent 1, "Error message from " & productName & " uninstall script: " & strMessage
End Function